import SwiftUI
import UIKit


struct StartView: View {
    
    @StateObject var advancedOptions = AdvancedOptions()
    @StateObject var cardknoxSDKManager = CardknoxSDKManager()
    
    private var paymnentEngineViewEnabled = true;
    
    init() {
        
        
        // Version check
        // 1. read from the SDK
        let version = CardknoxSDK.getVersion() as! CardknoxSDKVersion
        NSLog("Cardknox SDK version: %@", version.description());
        
        // 2. Read from the SDK Bundle
        var bundle : Bundle? = Bundle.init(identifier: "com.gateway.cardknox.iosapp")
        var shortVersion = "N/A";
        var buildVersion = "N/A";
        if(bundle != nil){
            shortVersion = bundle!.infoDictionary?["CFBundleShortVersionString"] as? String ?? "N/A"
            buildVersion = bundle!.infoDictionary?["CFBundleVersion"] as? String ?? "N/A"
        }
        NSLog("Cardknox SDK version: bundle: %@", "Version \(shortVersion) (\(buildVersion))");
        
        // Documentation purposes
        if(false)
        {
let ver = CardknoxSDK.getVersion() as! CardknoxSDKVersion
// Read the version in format "major.minor.patch.build"
let semanticVersion = ver.description();
// Access individual parts as well
let major : Int32 = ver.major;
let minor : Int32 = ver.minor;
let patch : Int32 = ver.patch;
let build : Int32 = ver.build;
        }
        
        let appearance = UITabBarAppearance()
        appearance.stackedLayoutAppearance.normal.titleTextAttributes = [.foregroundColor : UIColor(named: "DefaultRed")]
        appearance.stackedLayoutAppearance.selected.titleTextAttributes = [.foregroundColor : UIColor(named: "DefaultRed")]
                
        appearance.stackedLayoutAppearance.normal.iconColor = UIColor(named: "DefaultRed")
        appearance.stackedLayoutAppearance.selected.iconColor = UIColor(named: "DefaultRed")
        UITabBar.appearance().standardAppearance = appearance
        
    }
    
    var body: some View
    {
        TabView
        {
            InScopeView().tabItem
            {
                Text("In scope")
                Image("TabbarItemIcon")
                    .renderingMode(.template)
            }
            .environmentObject(advancedOptions)
            .environmentObject(cardknoxSDKManager)
            .navigationBarHidden(true)
            
            OutOfScopeView().tabItem
            {
                Text("Out of scope")
                Image("TabbarItemIcon")
                    .renderingMode(.template)
            }
            .environmentObject(cardknoxSDKManager)
            
            CustomUIView().tabItem
            {
                Text("Custom UI")
                Image("TabbarItemIcon")
                    .renderingMode(.template)
            }
            .environmentObject(cardknoxSDKManager)
            
            if(paymnentEngineViewEnabled)
            {
                PaymentEngineView().tabItem
                {
                    Text("PaymentEngine")
                    Image("TabbarItemIcon")
                        .renderingMode(.template)
                }
                .environmentObject(cardknoxSDKManager)
            }
        }
    }
}

struct RoundedTextFieldWithBorderStyle: TextFieldStyle {
    func _body(configuration: TextField<Self._Label>) -> some View {
        configuration
            .font(Font.custom("SFProDisplay-Regular", size: 16))
            .multilineTextAlignment(TextAlignment.leading)
            .frame(height: 44)
            .padding([.leading, .trailing], 11)
            .background(RoundedRectangle(cornerRadius: 6).strokeBorder(Color("Gray2"), style: StrokeStyle(lineWidth: 1)))
    }
}

struct TextFieldWithImage : View
{
    @State var placeholder: String = ""
    @State var text: String = ""
    var body: some View
    {
        HStack
        {
            TextField(self.placeholder, text: self.$text)
            Image("ArrowDown_24")
                .frame(width: 24, height: 24, alignment: Alignment.center)
        }
        .padding()
        .frame(height: 44)
        .overlay(RoundedRectangle(cornerRadius: 6).strokeBorder(Color("Gray2"), style: StrokeStyle(lineWidth: 1)))
    }
}

struct RedButton: ButtonStyle {
    func makeBody(configuration: Configuration) -> some View {
        configuration
            .label
            .padding()
            .frame(maxWidth: .infinity, maxHeight: 44)
            .foregroundColor(Color.white)
            .background(Color("DefaultRed"))
            .cornerRadius(6)
    }
}

struct WhiteButton: ButtonStyle {
    func makeBody(configuration: Configuration) -> some View {
        configuration
            .label
            .padding()
            .frame(maxWidth: .infinity, maxHeight: 44)
            .foregroundColor(Color("DefaultRed"))
            .background(RoundedRectangle(cornerRadius: 6)
                            .strokeBorder(Color("Gray2"), style: StrokeStyle(lineWidth: 1))
                            .background(Color.white))
    }
}
