import Foundation
import SwiftUI

struct ScanningTimeoutPickerView : UIViewRepresentable {
    @Binding var text : String?
    
    private let textField = UITextField()
    private let picker = UIPickerView()

    func makeCoordinator() -> ScanningTimeoutPickerView.ScanningTimeoutCoordinator {
        ScanningTimeoutCoordinator(pickerView: self)
    }
    
    func makeUIView(context: UIViewRepresentableContext<ScanningTimeoutPickerView>) -> UITextField {
        picker.delegate = context.coordinator
        picker.dataSource = context.coordinator
        picker.tintColor = .black
        textField.placeholder = "Scanning timeout"
        textField.inputView = picker
        textField.textColor = UIColor.init(named: "Gray4")
        textField.font = UIFont(name: "SFProDisplay-Regular", size: 16)
        
        picker.selectRow(0, inComponent: 0, animated: false)
        context.coordinator.pickerView(picker, didSelectRow: 0, inComponent: 0)
        return textField
    }
    
    func updateUIView(_ uiView: UITextField, context: UIViewRepresentableContext<ScanningTimeoutPickerView>) {
        uiView.text = text
     }

    class ScanningTimeoutCoordinator: NSObject, UIPickerViewDataSource, UIPickerViewDelegate
    {
        private let parent : ScanningTimeoutPickerView
        private let data : [String] = ["0", "20"]
        
        init(pickerView : ScanningTimeoutPickerView) {
            self.parent = pickerView
        }
        
        func numberOfComponents(in pickerView: UIPickerView) -> Int {
            return 1
        }
        
        func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
            return self.data.count
        }
        
        func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component:Int) -> String? {
            return self.data[row]
        }
        
        func pickerView(_ pickerView: UIPickerView, didSelectRow row: Int, inComponent component:Int)
        {
            DispatchQueue.main.async
            {
                self.parent.text = self.data[row]
            }
        }
    }
 }
