import Foundation
import SwiftUI

struct ScannedDevicePickerView : UIViewRepresentable {
    @Binding var selectDevice : CardknoxSDKCustomUIBLEScannedDevice?
    @Binding var dataSource: [CardknoxSDKCustomUIBLEScannedDevice]?
    
    private let textField = UITextField()
    private let picker = UIPickerView()

    func makeCoordinator() -> ScannedDevicePickerView.ScannedDeviceCoordinator {
        ScannedDeviceCoordinator(textfield: self)
    }
    
    func makeUIView(context: UIViewRepresentableContext<ScannedDevicePickerView>) -> UITextField {
        picker.delegate = context.coordinator
        picker.dataSource = context.coordinator
        picker.tintColor = .black
        textField.placeholder = "Select a scanned device"
        textField.inputView = picker
        textField.textColor = UIColor.init(named: "Gray4")
        textField.font = UIFont(name: "SFProDisplay-Regular", size: 16)
        return textField
    }
    
    func updateUIView(_ uiView: UITextField, context: UIViewRepresentableContext<ScannedDevicePickerView>) {
        var name = ""
        if(selectDevice != nil)
        {
            name = selectDevice?.name() ?? ""
            name += " - "
            name += selectDevice?.displayName() ?? ""
        }
        uiView.isEnabled = !(dataSource?.isEmpty ?? true)
        uiView.text = name
        uiView.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
     }

    class ScannedDeviceCoordinator: NSObject, UIPickerViewDataSource, UIPickerViewDelegate
    {
        private let parent : ScannedDevicePickerView
        
        init(textfield : ScannedDevicePickerView) {
            self.parent = textfield
        }
        
        func numberOfComponents(in pickerView: UIPickerView) -> Int {
            return 1
        }
        
        func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
            return (self.parent.dataSource?.count ?? 0)
        }
        
        func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component:Int) -> String? {
            let device = self.parent.dataSource![row]
            return device.name() + " - " + device.displayName()
        }
        
        func pickerView(_ pickerView: UIPickerView, didSelectRow row: Int, inComponent component:Int)
        {
            DispatchQueue.main.async
            {
                self.parent.selectDevice = self.parent.dataSource![row]
            }
        }
    }
 }
