import Foundation
import SwiftUI

struct ExpirationDatePickerView : UIViewRepresentable {
    @Binding var text : String?
    
    private let textField = UITextField()
    private let picker = UIPickerView()

    func makeCoordinator() -> ExpirationDatePickerView.ExpirationDateCoordinator {
        ExpirationDateCoordinator(pickerView: self)
    }
    
    func makeUIView(context: UIViewRepresentableContext<ExpirationDatePickerView>) -> UITextField {
        picker.delegate = context.coordinator
        picker.dataSource = context.coordinator
        picker.tintColor = .black
        textField.placeholder = "Expiration date"
        textField.inputView = picker
        textField.textColor = UIColor.init(named: "Gray4")
        textField.font = UIFont(name: "SFProDisplay-Regular", size: 16)
        
        
        let date = Date()
        let formatter = DateFormatter()
        formatter.dateFormat = "yy"
        let indexOfYear = context.coordinator.years.firstIndex(of: formatter.string(from: date)) ?? 0
        picker.selectRow(indexOfYear, inComponent: 1, animated: false)
        context.coordinator.pickerView(picker, didSelectRow: indexOfYear, inComponent: 1)
        
        formatter.dateFormat="MM"
        let indexOfMonth = context.coordinator.months.firstIndex(of: formatter.string(from: date)) ?? 0
        picker.selectRow(indexOfMonth, inComponent: 0, animated: false)
        context.coordinator.pickerView(picker, didSelectRow: indexOfMonth, inComponent: 0)
        return textField
    }
    
    func updateUIView(_ uiView: UITextField, context: UIViewRepresentableContext<ExpirationDatePickerView>) {
        uiView.text = text
     }

    class ExpirationDateCoordinator: NSObject, UIPickerViewDataSource, UIPickerViewDelegate
    {
        private let parent : ExpirationDatePickerView
        public var years : [String] = [String]()
        public var months : [String] = [String]()
        private var year : String = ""
        private var month : String = ""
        
        init(pickerView : ExpirationDatePickerView) {
            self.parent = pickerView
            for i in 0...99 {
                if(i < 10)
                {
                    years.append("0" + String(i))
                    if(i > 0)
                    {
                        months.append("0" + String(i))
                    }
                }
                else if(i < 13)
                {
                    years.append(String(i))
                    months.append(String(i))
                }
                else
                {
                    years.append(String(i))
                }
            }
            
        }
        
        func numberOfComponents(in pickerView: UIPickerView) -> Int {
            return 2
        }
        
        func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
            if(component == 0)
            {
                return months.count
            }
            else if (component == 1)
            {
                return years.count
            }
            else
            {
                return 0
            }
        }
        
        func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component:Int) -> String? {
            if(component == 0)
            {
                return months[row]
            }
            else if (component == 1)
            {
                return years[row]
            }
            else
            {
                return ""
            }
        }
        
        func pickerView(_ pickerView: UIPickerView, didSelectRow row: Int, inComponent component:Int)
        {
            DispatchQueue.main.async
            {
                if(component == 0)
                {
                    self.month = self.months[row]
                }
                else if (component == 1)
                {
                    self.year = self.years[row]
                }
                let expDate = self.month + "|" + self.year
                self.parent.text = expDate
            }
        }
    }
 }
