import Foundation
import SwiftUI

struct CommandTypePickerView : UIViewRepresentable {
    @Binding var text : String?
    
    private let textField = UITextField()
    private let picker = UIPickerView()

    func makeCoordinator() -> CommandTypePickerView.CommandTypeCoordinator {
        CommandTypeCoordinator(textfield: self)
    }
    
    func makeUIView(context: UIViewRepresentableContext<CommandTypePickerView>) -> UITextField {
        picker.delegate = context.coordinator
        picker.dataSource = context.coordinator
        picker.tintColor = .black
        textField.placeholder = "Choose transaction type"
        textField.inputView = picker
        textField.textColor = UIColor.init(named: "Gray4")
        textField.font = UIFont(name: "SFProDisplay-Regular", size: 16)
        
        picker.selectRow(0, inComponent: 0, animated: false)
        context.coordinator.pickerView(picker, didSelectRow: 0, inComponent: 0)
        return textField
    }
    
    func updateUIView(_ uiView: UITextField, context: UIViewRepresentableContext<CommandTypePickerView>) {
        uiView.text = text
     }

    class CommandTypeCoordinator: NSObject, UIPickerViewDataSource, UIPickerViewDelegate
    {
        private let parent : CommandTypePickerView
        private let data : [String] = [Commands.CCSale, Commands.CCCredit, Commands.CCAuthonly, Commands.CCCapture]
        
        init(textfield : CommandTypePickerView) {
            self.parent = textfield
        }
        
        func numberOfComponents(in pickerView: UIPickerView) -> Int {
            return 1
        }
        
        func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
            return self.data.count
        }
        
        func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component:Int) -> String? {
            return self.data[row]
        }
        
        func pickerView(_ pickerView: UIPickerView, didSelectRow row: Int, inComponent component:Int)
        {
            DispatchQueue.main.async
            {
                let selected = self.data[row]
                self.parent.text = selected
            }
        }
    }
 }

class Commands
{
    static let CCSale : String = "cc:sale"
    static let CCCredit : String = "cc:credit"
    static let CCAuthonly : String = "cc:authonly"
    static let CCCapture : String = "cc:capture"
    
    static func isRefNum(command : String) -> Bool
    {
        if(command.elementsEqual(CCCapture))
        {
            return true
        }
        else
        {
            return false
        }
    }
}
