import Foundation

class CardknoxSDKManager : ObservableObject
{
    func getCardknoxSDKDirect() -> CardknoxSDKDirect!
    {
        let cardknoxSdk: CardknoxSDK = CardknoxSDK.create() as! CardknoxSDK;
        return cardknoxSdk.getInScope() as! CardknoxSDKDirect
    }
    
    func getCardknoxSDKUI() -> CardknoxSDKUI!
    {
        let cardknoxSdk: CardknoxSDK = CardknoxSDK.create() as! CardknoxSDK;
        return cardknoxSdk.getOutOfScope() as! CardknoxSDKUI
    }
    
    func getCardknoxSDKCustomUIBluetooth() -> CardknoxSDKCustomUIBLE!
    {
        let cardknoxSdk: CardknoxSDK = CardknoxSDK.create() as! CardknoxSDK;
        return cardknoxSdk.getCustomUIBluetooth() as! CardknoxSDKCustomUIBLE
    }
    
    func getCardknoxSDKCustomUIUSB() -> CardknoxSDKCustomUIBLE!
    {
        let cardknoxSdk: CardknoxSDK = CardknoxSDK.create() as! CardknoxSDK;
        return cardknoxSdk.getCustomUIUSB() as! CardknoxSDKCustomUIBLE
    }
    
    
    func getCardknoxSDKPaymentEngine() -> CardknoxPaymentEngineSDK!
    {
        let cardknoxSdk: CardknoxSDK = CardknoxSDK.create() as! CardknoxSDK;
        return cardknoxSdk.getPaymentEngine() as! CardknoxPaymentEngineSDK
    }
}

