import Foundation
import SwiftUI

struct AdvancedOptionsView : View
{
    @Binding var showSelf: Bool
    @EnvironmentObject var advancedOptionsModel: AdvancedOptions
    var body: some View
    {
        ScrollView(.vertical)
        {
            VStack(spacing: 21)
            {
                Button(action: doneButtonClick)
                {
                    HStack {
                        Image("ArrowLeft_24")
                        Text("Done")
                            .foregroundColor(Color.black)
                    }
                    
                }
                .frame(maxWidth: .infinity, alignment: .leading)
                
                Group{
                    VStack(spacing: 15)
                    {
                        Text("Transaction details")
                            .font(Font.custom("SFProDisplay-Semibold", size: 18))
                            .frame(maxWidth: .infinity, alignment: .leading)
                        
                        Divider()
                            .frame(maxWidth: .infinity, maxHeight: 1)
                            .background(Color("Gray1"))
                        
                    }
                    
                    TextField("Invoice", text: self.$advancedOptionsModel.Invoice)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("PO Number", text: self.$advancedOptionsModel.PONumber)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("Description", text: self.$advancedOptionsModel.Description)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                }
                
                Group{
                    VStack(spacing: 15)
                    {
                        Text("Billing information")
                            .font(Font.custom("SFProDisplay-Semibold", size: 18))
                            .frame(maxWidth: .infinity, alignment: .leading)
                        
                        Divider()
                            .frame(maxWidth: .infinity, maxHeight: 1)
                            .background(Color("Gray1"))
                        
                    }
                    
                    TextField("First Name", text: self.$advancedOptionsModel.BillFirstName)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("Last Name", text: self.$advancedOptionsModel.BillLastName)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("Company", text: self.$advancedOptionsModel.BillCompany)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("Address", text: self.$advancedOptionsModel.BillAddress)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("City", text: self.$advancedOptionsModel.BillCity)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("State", text: self.$advancedOptionsModel.BillState)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("Zip", text: self.$advancedOptionsModel.BillZip)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    HStack
                    {
                        CountryPickerView(text: $advancedOptionsModel.BillCountry)
                        Image("ArrowDown_24")
                            .frame(width: 24, height: 24, alignment: Alignment.center)
                    }
                    .padding()
                    .frame(height: 44)
                    .background(RoundedRectangle(cornerRadius: 6).strokeBorder(Color("Gray2"), style: StrokeStyle(lineWidth: 1)))
                    
                    TextField("Phone Number", text: self.$advancedOptionsModel.BillPhoneNumber)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                }
                
                Group
                {
                    VStack(spacing: 15)
                    {
                        Text("Shipping information")
                            .font(Font.custom("SFProDisplay-Semibold", size: 18))
                            .frame(maxWidth: .infinity, alignment: .leading)
                        
                        Divider()
                            .frame(maxWidth: .infinity, maxHeight: 1)
                            .background(Color("Gray1"))
                        
                    }
                    
                    TextField("First Name", text: self.$advancedOptionsModel.ShipFirstName)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("Last Name", text: self.$advancedOptionsModel.ShipLastName)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("Company", text: self.$advancedOptionsModel.ShipCompany)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("Address", text: self.$advancedOptionsModel.ShipAddress)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("City", text: self.$advancedOptionsModel.ShipCity)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("State", text: self.$advancedOptionsModel.ShipState)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    TextField("Zip", text: self.$advancedOptionsModel.ShipZip)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                    
                    HStack
                    {
                        CountryPickerView(text: $advancedOptionsModel.ShipCountry)
                        Image("ArrowDown_24")
                            .frame(width: 24, height: 24, alignment: Alignment.center)
                    }
                    .padding()
                    .frame(height: 44)
                    .background(RoundedRectangle(cornerRadius: 6).strokeBorder(Color("Gray2"), style: StrokeStyle(lineWidth: 1)))
                    
                    TextField("Phone Number", text: self.$advancedOptionsModel.ShipPhoneNumber)
                        .textFieldStyle(RoundedTextFieldWithBorderStyle())
                }
            }
            .frame(maxWidth: .infinity, maxHeight: .infinity, alignment: Alignment.topLeading)
        }
        .navigationBarHidden(true)
        .padding(20)
        .background(Color.white)
        .onTapGesture {self.hideKeyboard()}
    }
    
    func doneButtonClick()
    {
        showSelf = false
    }
}

class AdvancedOptions: ObservableObject {
    @Published var Invoice: String = ""
    @Published var PONumber: String = ""
    @Published var Description: String = ""
    
    @Published var BillFirstName: String = ""
    @Published var BillLastName: String = ""
    @Published var BillCompany: String = ""
    @Published var BillAddress: String = ""
    @Published var BillCity: String = ""
    @Published var BillState: String = ""
    @Published var BillZip: String = ""
    @Published var BillCountry: String = ""
    @Published var BillPhoneNumber: String = ""
    
    @Published var ShipFirstName: String = ""
    @Published var ShipLastName: String = ""
    @Published var ShipCompany: String = ""
    @Published var ShipAddress: String = ""
    @Published var ShipCity: String = ""
    @Published var ShipState: String = ""
    @Published var ShipZip: String = ""
    @Published var ShipCountry: String = ""
    @Published var ShipPhoneNumber: String = ""
}

