package com.cardknox.android.sdk.sampleapp2.options;

import android.content.Context;
import android.content.Intent;

import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import cardknox.payments.sdk.TransactionParameters;

public class TransactionParametersContract extends ActivityResultContract<TransactionParameters, TransactionParameters>
{
    @NonNull
    @Override
    public Intent createIntent(@NonNull Context context, TransactionParameters initial) {

        AdvancedOptionsActivity.SetInitialParameters(initial);
        return new Intent(context, AdvancedOptionsActivity.class);
    }

    @Override
    public TransactionParameters parseResult(int resultCode, @Nullable Intent intent) {
        return AdvancedOptionsActivity.GetAndDestroyCurrentParameters();
    }
}
