package com.cardknox.android.sdk.sampleapp2.options;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.renderscript.Sampler;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;

import com.cardknox.android.sdk.sampleapp2.R;
import com.cardknox.android.sdk.sampleapp2.Utils;
import com.cardknox.android.sdk.sampleapp2.data.Countries;
import com.cardknox.android.sdk.sampleapp2.databinding.ActivityAdvancedOptionsBinding;
import com.google.gson.Gson;

import cardknox.payments.sdk.TransactionParameters;

public class AdvancedOptionsActivity extends AppCompatActivity {

    private static TransactionParameters currentParameters;
    private ActivityAdvancedOptionsBinding binding;

    public static void SetInitialParameters(TransactionParameters initial){
        AdvancedOptionsActivity.currentParameters = initial;
    }

    public static TransactionParameters GetAndDestroyCurrentParameters(){
        // Snapshot
        TransactionParameters result = AdvancedOptionsActivity.currentParameters;
        AdvancedOptionsActivity.currentParameters = null;
        return result;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityAdvancedOptionsBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        setSupportActionBar(binding.toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        InitializeViews();
        InitializeViewsChanging();
        SetViewValues();
    }

    /**
     * Required for the home back to perform 'back pressed'
     * Home button configured with {@link androidx.appcompat.app.ActionBar#setDisplayHomeAsUpEnabled(boolean)}}
     * in {@link AdvancedOptionsActivity#onCreate(Bundle)}
     * */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                return true;
        }

        return super.onOptionsItemSelected(item);
    }

    private void SetViewValues() {
        binding.invoice.setText(currentParameters.GetxInvoice());
        binding.poNumber.setText(currentParameters.GetxPoNum());
        binding.description.setText(currentParameters.GetxDescription());

        binding.billingFirstName.setText(currentParameters.GetxBillFirstName());
        binding.billingLastName.setText(currentParameters.GetxBillLastName());
        binding.billingCompany.setText(currentParameters.GetxBillCompany());
        binding.billingAddress.setText(currentParameters.GetxBillStreet());
        binding.billingCity.setText(currentParameters.GetxBillCity());
        binding.billingState.setText(currentParameters.GetxBillState());
        binding.billingZip.setText(currentParameters.GetxBillZip());
        binding.billingPhoneNumber.setText(currentParameters.GetxBillPhone());
        String billingCountryName = currentParameters.GetxBillCountry();
        if (billingCountryName != null && binding.spinnerBillingCountry.getAdapter() != null) {
            ArrayAdapter<String> countries = (ArrayAdapter<String>) binding.spinnerBillingCountry.getAdapter();
            int pos = countries.getPosition(billingCountryName);
            binding.spinnerBillingCountry.setSelection(pos);
        }

        binding.shippingFirstName.setText(currentParameters.GetxShipFirstName());
        binding.shippingLastName.setText(currentParameters.GetxShipLastName());
        binding.shippingCompany.setText(currentParameters.GetxShipCompany());
        binding.shippingAddress.setText(currentParameters.GetxShipStreet());
        binding.shippingCity.setText(currentParameters.GetxShipCity());
        binding.shippingState.setText(currentParameters.GetxShipState());
        binding.shippingZip.setText(currentParameters.GetxShipZip());
        binding.shippingPhoneNumber.setText(currentParameters.GetxShipPhone());

        String shippingCountryName = currentParameters.GetxShipCountry();
        if (shippingCountryName != null && binding.spinnerShippingCountry.getAdapter() != null) {
            ArrayAdapter<String> countries = (ArrayAdapter<String>) binding.spinnerShippingCountry.getAdapter();
            int pos = countries.getPosition(shippingCountryName);
            binding.spinnerShippingCountry.setSelection(pos);
        }

        binding.custom01.setText(currentParameters.GetxCustom01());
        binding.custom02.setText(currentParameters.GetxCustom02());
        binding.custom03.setText(currentParameters.GetxCustom03());
    }

    private void InitializeViews()
    {
        // Countries pickers
        ArrayAdapter<String> aa = new ArrayAdapter<String>(this,
                R.layout.my_simple_spinner_item,
                Countries.Countries);
        aa.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        binding.spinnerBillingCountry.setAdapter(aa);

        ArrayAdapter<String> shippingCountries = new ArrayAdapter<String>(this,
                R.layout.my_simple_spinner_item,
                Countries.Countries);
        shippingCountries.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        binding.spinnerShippingCountry.setAdapter(shippingCountries);
    }

    private void InitializeViewsChanging()
    {
        // Transaction details
        OnFocusChange(binding.invoice, value -> currentParameters.SetxInvoice(value));
        OnFocusChange(binding.poNumber, value -> currentParameters.SetxPoNum(value));
        OnFocusChange(binding.description, value -> currentParameters.SetxDescription(value));

        // Billing information
        OnFocusChange(binding.billingFirstName, value -> currentParameters.SetxBillFirstName(value));
        OnFocusChange(binding.billingLastName, value -> currentParameters.SetxBillLastName(value));
        OnFocusChange(binding.billingCompany, value -> currentParameters.SetxBillCompany(value));
        OnFocusChange(binding.billingAddress, value -> currentParameters.SetxBillStreet(value));
        OnFocusChange(binding.billingCity, value -> currentParameters.SetxBillCity(value));
        OnFocusChange(binding.billingState, value -> currentParameters.SetxBillState(value));
        OnFocusChange(binding.billingZip, value -> currentParameters.SetxBillZip(value));
        OnFocusChange(binding.billingPhoneNumber, value -> currentParameters.SetxBillPhone(value));

        // Shipping information
        OnFocusChange(binding.shippingFirstName, value -> currentParameters.SetxShipFirstName(value));
        OnFocusChange(binding.shippingLastName, value -> currentParameters.SetxShipLastName(value));
        OnFocusChange(binding.shippingCompany, value -> currentParameters.SetxShipCompany(value));
        OnFocusChange(binding.shippingAddress, value -> currentParameters.SetxShipStreet(value));
        OnFocusChange(binding.shippingCity, value -> currentParameters.SetxShipCity(value));
        OnFocusChange(binding.shippingState, value -> currentParameters.SetxShipState(value));
        OnFocusChange(binding.shippingZip, value -> currentParameters.SetxShipZip(value));
        OnFocusChange(binding.shippingPhoneNumber, value -> currentParameters.SetxShipPhone(value));

        // Spinners
        binding.spinnerBillingCountry.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                ArrayAdapter<String> typedAdapter = (ArrayAdapter<String>) parent.getAdapter();
                String newCountryName = typedAdapter.getItem(position);
                Utils.log(String.format("[billing country spinner]-[onItemSelected]: saving value '%s'", newCountryName));
                currentParameters.SetxBillCountry(newCountryName);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                currentParameters.SetxBillCountry(null);
            }
        });

        binding.spinnerShippingCountry.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                ArrayAdapter<String> typedAdapter = (ArrayAdapter<String>) parent.getAdapter();
                String newCountryName = typedAdapter.getItem(position);
                Utils.log(String.format("[shipping country spinner]-[onItemSelected]: saving value '%s'", newCountryName));
                currentParameters.SetxShipCountry(newCountryName);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                currentParameters.SetxShipCountry(null);
            }
        });
    }

    private <T extends EditText> void OnFocusChange(T source, StringValueReceiver receiver){
        source.setOnFocusChangeListener((v, hasFocus) -> {
            if(!hasFocus)
            {
                String newText = source.getText().toString();
                Utils.log(String.format("[onFocusChange]: saving value '%s'", newText));
                receiver.receive(newText);
            }
        });
    }

    public interface StringValueReceiver{
        void receive(String value);
    }


}

