package com.cardknox.android.sdk.sampleapp2.docs.samples;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import androidx.fragment.app.Fragment;

import cardknox.payments.sdk.CardknoxPaymentEngineSDK;
import cardknox.payments.sdk.CardknoxPaymentEngineSDKRequest;
import cardknox.payments.sdk.CardknoxPaymentEngineSDKResponseJSON;
import cardknox.payments.sdk.CardknoxPaymentEngineSDKSettings;
import cardknox.payments.sdk.CardknoxSDK;

public class PaymentEngineExampleFragment extends Fragment {

    private void SetupReceivePaymentEngineResponseAsJSON(){
        Context applicationContext = null;
        CardknoxSDK.create().getPaymentEngine().SetSendResponseAsJSON(true);
        try { applicationContext.unregisterReceiver(Result_PaymentEngineResponseAsJSON);} catch(Exception e) {}
        applicationContext.registerReceiver(Result_PaymentEngineResponseAsJSON, new IntentFilter(CardknoxPaymentEngineSDK.PAYMENTENGINE_JSON_INTENTFILTER_ACTION()));
    }

    private final BroadcastReceiver Result_PaymentEngineResponseAsJSON = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {

            String action = intent.getAction();
            // Verify that the Cardknox SDK broadcasted the Intent
            if (action != null && action.equals(CardknoxPaymentEngineSDK.PAYMENTENGINE_JSON_INTENTFILTER_ACTION())) {

                String extraKey = CardknoxPaymentEngineSDK.PAYMENTENGINE_JSON_INTENTFILTER_EXTRA();
                java.lang.Object extra = intent.getParcelableExtra(extraKey);
                // Cast
                CardknoxPaymentEngineSDKResponseJSON response = (CardknoxPaymentEngineSDKResponseJSON) extra;
                String json = response.GetJSON();
            }
        }
    };

    private void SetupPaymentEngineBroadcastsLogCatMessages(){
        Context context = null;
        CardknoxPaymentEngineSDK paymentEngine = CardknoxSDK.create().getPaymentEngine();
        // PaymentEngine logging, 2 options:
        // 1. SDK writes the PE log to LogCat directly
        // 2. SDK sends the PE log it wants to write to this app (via BroadcastReceiver)
        // Note: calling 1 method negates the other one
        boolean broadcast = false;
        boolean writeDirectly = true;
        if(broadcast && writeDirectly)
            throw new RuntimeException("PE logs can either be directly written to LogCat or broadcasted back to this app, not both");

        if(writeDirectly){
            paymentEngine.enableLogCatOutput("LogCatTag");
        }
        else if(broadcast){
            paymentEngine.enableLogCatBroadcasts(true);
            // subscribe to logcat broadcasts
            try { context.unregisterReceiver(Receiver_LogcatMessages);} catch(Exception e) {}
            context.registerReceiver(Receiver_LogcatMessages, new IntentFilter(CardknoxPaymentEngineSDK.LOGGER_INTENTFILTER_ACTION()));
        }
    }

    private final BroadcastReceiver Receiver_LogcatMessages = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if(intent != null) {
                String action = intent.getAction();
                if (action != null && action.equals(CardknoxPaymentEngineSDK.LOGGER_INTENTFILTER_ACTION())) {
                    String logcatMessage = "unknown";

                    String extraKey= CardknoxPaymentEngineSDK.LOGGER_INTENTFILTER_EXTRA();
                    if(intent.hasExtra(extraKey))
                        logcatMessage = intent.getStringExtra(extraKey);

                    android.util.Log.d("SomeTag", logcatMessage);
                }
            }
        }
    };


    private void Device_ReprintReceipt_Example(){
        CardknoxPaymentEngineSDKSettings settings = new CardknoxPaymentEngineSDKSettings();
        settings.SetDevice_IP_Address("specify IP");
        settings.SetDevice_IP_Port("specify port");
        settings.SetDevice_Name("specify device name, such as PAX_A77.3");
        settings.SetDevice_Timeout(5 * 1000); /* milliseconds to seconds */

        CardknoxPaymentEngineSDKRequest request = new CardknoxPaymentEngineSDKRequest();
        request.SetxAuthCode("add auth code here");

        String response = CardknoxSDK.create().getPaymentEngine().Device_ReprintReceipt(settings, request);
        boolean success = response.equals("OK");
    }

}
