package com.cardknox.android.sdk.sampleapp2.docs.samples;

import androidx.fragment.app.Fragment;

import com.cardknox.android.sdk.sampleapp2.MainActivity2;

import cardknox.payments.sdk.CardknoxSDK;
import cardknox.payments.sdk.PaymentTransactionRequestUI;
import cardknox.payments.sdk.TransactionParameters;

public class OutOfScopeExampleFragment extends Fragment {

    private void processOutOfScope()
    {
        CardknoxSDK.create().setPrincipalKey(MainActivity2.KEY);

        // Supply the Cardknox SDK with the required values:
        // xSoftware name: name of your application
        // xVersion: Cardknox Gateway version. Currently 4.5.9
        CardknoxSDK.create().setSoftwareConfigurations(
                // xSoftwareName
                "Android app - process out of scope",
                // xVersion
                "4.5.9");


        // Create the parameters object
        TransactionParameters parameters = new TransactionParameters()
        {
            {
                // Required parameters
                // 1. command to use. One of the Cardknox Transaction API commands
                SetxCommand("cc:sale");
                // 2. amount
                SetxAmount(1.23);

                // Supplementary parameters
                // 1. card number - will be prefilled on the keyed form
                SetxCardNum("4444333322221111");

                // 2. expiration date - will be prefilled on the keyed form
                // Format "MMYY"
                // For example: December 2024
                SetxExp("1224");

                // Optional parameters to supplement the transaction
                // All of the available parameters will be sent to the gateway
                SetxInvoice("1234");
                SetxBillCity("New York");
                // ... other optional parameters.
            }
        };

        // Define global screen accessibility before creating a Request object via the SDK.
        // Changing these values after the Request is created will not have an affect until the
        // Request is re-created.
        CardknoxSDK.create().getOutOfScope().SetEnableDeviceInsertSwipeTap(true);
        CardknoxSDK.create().getOutOfScope().SetEnableKeyedEntry(true);

        // Configure what should happen once the UI processes a transaction
        // If the SDK should not close itself, then the transaction processing results are displayed in a modal window.
        // Otherwise the SDK auto closes its' UI.
        CardknoxSDK.create().getOutOfScope().SetCloseSDKUIOnProcessedTransaction(false);

        PaymentTransactionRequestUI request = CardknoxSDK.create().getOutOfScope().createRequestWithParameters(parameters);

        if(request.GetIsValid()){
            // Supply the Activity reference here.
            // In fragments, that might be a 'getActivity()' call.
            android.app.Activity activity = null;

            // Show Cardknox SDK UI
            request.process(activity);
        } else {
            // Extract all validation errors that block
            // the request object from showing the SDK UI
            String[] validationErrors = request.GetValidationErrors();
        }
    }
}
