package com.cardknox.android.sdk.sampleapp2.docs.samples;

import androidx.fragment.app.Fragment;

import com.cardknox.android.sdk.sampleapp2.MainActivity2;

import cardknox.payments.sdk.CardknoxSDK;
import cardknox.payments.sdk.PaymentTransactionRequestDirect;
import cardknox.payments.sdk.PaymentTransactionResponse;
import cardknox.payments.sdk.TransactionParameters;

public class InScopeExampleFragment extends Fragment {

    private void processInScope()
    {
        // xKey to use
        CardknoxSDK.create().setPrincipalKey(MainActivity2.KEY);



        // Supply the Cardknox SDK with the required values:
        // xSoftware name: name of your application
        // xVersion: Cardknox Gateway version. Currently 4.5.9
        CardknoxSDK.create().setSoftwareConfigurations(
                // xSoftwareName
                "Android app - process in scope",
                // xVersion
                "4.5.9");

        // Create the parameters object
        TransactionParameters parameters = new TransactionParameters()
        {
            {
                // Required parameters
                SetxCommand("cc:sale");
                SetxAmount(1.23);
                SetxCardNum("4444333322221111");
                // Format "MMYY"
                // For example: December 2024
                SetxExp("1224");

                // Optional parameters to supplement the transaction
                SetxInvoice("1234");
            }
        };

        // Create the request object
        PaymentTransactionRequestDirect request = CardknoxSDK.create().getInScope().createRequestWithParameters(parameters);

        if(request.GetIsValid()) {
            PaymentTransactionResponse response = request.process();

            boolean isSuccess = response.GetIsSuccess();
            String errorMessage = response.GetErrorMessage();
            String errorCode = response.GetxErrorCode();
            String refNum = response.GetxRefNum();
        }
        else {
            String[] errors = request.GetValidationErrors();
        }
    }
}
