package com.cardknox.android.sdk.sampleapp2.docs.samples;

import androidx.fragment.app.Fragment;

import cardknox.payments.sdk.CardknoxSDK;
import cardknox.payments.sdk.CardknoxSDKCustomUIBLE;
import cardknox.payments.sdk.TransactionParameters;

public class CustomUIBLEExampleFragment extends Fragment {
    private void Function_Create() {
        CardknoxSDKCustomUIBLE ble = CardknoxSDK.create().getCustomUIBluetooth();
    }

    private void Function_Destroy() {
        CardknoxSDK.create().destroy();
    }

    private void Function_StartScanning(){
        // Indefinite scan until stopped
        CardknoxSDK.create().getCustomUIBluetooth().startScanningWithTimeout(0);

        // Scan with a timeout
        CardknoxSDK.create().getCustomUIBluetooth().startScanningWithTimeout(20);
    }

    private void Function_StopScanning(){
        CardknoxSDK.create().getCustomUIBluetooth().stopScanning();
    }

    private void Function_ConnectToDevice(){
        String deviceName = "IDTech-VP3300-12345";
        CardknoxSDK.create().getCustomUIBluetooth().connectWithName(deviceName);
    }

    private void Function_ConnectWithAddress(){
        String address = "11:22:33:44:55";
        CardknoxSDK.create().getCustomUIBluetooth().connectWithAddress(address);
    }

    private void Function_DisconnectFromCurrentDevice(){
        CardknoxSDK.create().getCustomUIBluetooth().disconnectFromCurrentDevice();
    }

    private void Function_StartTransaction(){
        CardknoxSDKCustomUIBLE customUI = CardknoxSDK.create().getCustomUIBluetooth();
        TransactionParameters prms = new TransactionParameters();
        prms.SetxAmount(1.23);
        prms.SetxInvoice("1234");
        prms.SetxCommand("cc:sale");
        prms.SetVP3300TransactionTimeout(13);
        customUI.startTransactionWithArgs(prms);
    }

    private void Function_CancelTransaction(){
        CardknoxSDK.create().getCustomUIBluetooth().cancelTransaction();
    }
}
