package com.cardknox.android.sdk.sampleapp2.docs;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.cardknox.android.sdk.sampleapp2.Utils;

import cardknox.payments.sdk.CardknoxSDK;
import cardknox.payments.sdk.PaymentTransactionResponse;

public class TransactionResultExampleFragment extends Fragment {

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        RegisterIntentFilters();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        UnregisterIntentFilters();
    }

    private void RegisterIntentFilters()
    {
        Context c = getContext();

        if(c != null)
        {
            Utils.tryRegisterReceiver(c,  Receiver_TransactionProcessing, new IntentFilter(CardknoxSDK.TRANSACTION_CALLBACK_INTENTFILTER_ACTION()));
        }
    }

    private void UnregisterIntentFilters()
    {
        Context c = this.getContext();

        if(c != null)
        {
            Utils.tryUnregisterReceiver(c, Receiver_TransactionProcessing);
        }
    }

    private final BroadcastReceiver Receiver_TransactionProcessing = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDK.TRANSACTION_CALLBACK_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDK.TRANSACTION_CALLBACK_INTENTFILTER_EXTRA();
                java.lang.Object extra = intent.getParcelableExtra(extraKey);

                // Cast the 'extra' to the Cardknox SDK response type
                PaymentTransactionResponse response = (PaymentTransactionResponse)extra;

                if(response.GetIsSuccess())
                {
                    // Transaction successfully processed
                    String xRefNum = response.GetxRefNum();
                    // approved, declined, ...
                    String xStatus = response.GetxStatus();
                    String cvv = response.GetxCvvResult();
                    String avs = response.GetxAvsResult();
                    // ... other properties ...

                    Output("Transaction approved. Ref num: " + xRefNum);
                }
                else
                {
                    // Transaction processing resulted in an error; message can be extracted from this property:
                    String errorMessage = response.GetErrorMessage();
                    String errorCode = response.GetxErrorCode();
                    String error = response.GetxError();

                    Output("Transaction declined/errored. Ref num: " + response.GetxRefNum());
                }
            }
        }
    };

    private void Output(String text)
    {
        android.util.Log.d("ExampleTag", text);
    }
}