package com.cardknox.android.sdk.sampleapp2.docs;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.cardknox.android.sdk.sampleapp2.Utils;

import cardknox.payments.sdk.CardknoxSDKCustomUIBLE;
import cardknox.payments.sdk.CardknoxSDKCustomUIBLEScannedDevice;

public class ScannedDeviceExampleFragment extends Fragment {
    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        RegisterIntentFilters();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        UnregisterIntentFilters();
    }

    private void RegisterIntentFilters()
    {
        Context c = getContext();

        if(c != null)
        {
            Utils.tryRegisterReceiver(c, Receiver_ScannedDevice, new IntentFilter(CardknoxSDKCustomUIBLE.SCANNED_DEVICE_INTENTFILTER_ACTION()));
        }
    }

    private void UnregisterIntentFilters()
    {
        Context c = this.getContext();

        if(c != null)
        {
            Utils.tryUnregisterReceiver(c, Receiver_ScannedDevice);
        }
    }

    private final BroadcastReceiver Receiver_ScannedDevice = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDKCustomUIBLE.SCANNED_DEVICE_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDKCustomUIBLE.SCANNED_DEVICE_INTENTFILTER_EXTRA();
                java.lang.Object extra = intent.getParcelableExtra(extraKey);

                CardknoxSDKCustomUIBLEScannedDevice device = (CardknoxSDKCustomUIBLEScannedDevice) extra;

                // Can be used with a 'connect' method, like so:
                String address = device.GetAddress();
                CardknoxSDKCustomUIBLE example = null;
                example.connectWithAddress(address);

                // Output various data about the device
                Output("Scanned device name: " + device.GetName());
                Output("Scanned device display name: " + device.GetDisplayName());
                Output("Scanned device address: " + device.GetAddress());
            }
        }
    };

    private void Output(String text)
    {
        android.util.Log.d("ExampleTag", text);
    }
}
