package com.cardknox.android.sdk.sampleapp2.docs;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.cardknox.android.sdk.sampleapp2.Utils;

import cardknox.payments.sdk.CardknoxSDKCustomUIBLE;
import cardknox.payments.sdk.CardknoxSDKCustomUIBLEScanCompleted;
import cardknox.payments.sdk.CardknoxSDKCustomUIBLEScannedDevice;

public class ScanCompletedExampleFragment extends Fragment {
    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        RegisterIntentFilters();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        UnregisterIntentFilters();
    }

    private void RegisterIntentFilters()
    {
        Context c = getContext();

        if(c != null)
        {
            Utils.tryRegisterReceiver(c, Receiver_ScanCompleted, new IntentFilter(CardknoxSDKCustomUIBLE.SCAN_COMPLETED_INTENTFILTER_ACTION()));
        }
    }

    private void UnregisterIntentFilters()
    {
        Context c = this.getContext();

        if(c != null)
        {
            Utils.tryUnregisterReceiver(c, Receiver_ScanCompleted);
        }
    }

    private final BroadcastReceiver Receiver_ScanCompleted = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDKCustomUIBLE.SCAN_COMPLETED_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDKCustomUIBLE.SCAN_COMPLETED_INTENTFILTER_EXTRA();
                java.lang.Object extra = intent.getParcelableExtra(extraKey);
                CardknoxSDKCustomUIBLEScanCompleted scanCompleted = (CardknoxSDKCustomUIBLEScanCompleted) extra;

                if(scanCompleted != null && scanCompleted.scannedDevices() != null &&
                        scanCompleted.scannedDevices().size() > 0)
                {
                    for (Object d : scanCompleted.scannedDevices()) {
                        CardknoxSDKCustomUIBLEScannedDevice device = (CardknoxSDKCustomUIBLEScannedDevice)d;

                        // Can be used with a 'connect' method, like so:
                        String address = device.GetAddress();
                        CardknoxSDKCustomUIBLE example = null;
                        example.connectWithAddress(address);

                        // Output various data about the device
                        Output("Scanned device name: " + device.GetName());
                        Output("Scanned device display name: " + device.GetDisplayName());
                        Output("Scanned device address: " + device.GetAddress());
                    }
                }
            }
        }
    };

    private void Output(String text)
    {
        android.util.Log.d("ExampleTag", text);
    }
}
