package com.cardknox.android.sdk.sampleapp2.docs;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.cardknox.android.sdk.sampleapp2.Utils;

import cardknox.payments.sdk.CardknoxCardReaderCallback;
import cardknox.payments.sdk.CardknoxCardReaderCallbackType;
import cardknox.payments.sdk.CardknoxSDK;

public class CardReaderEventsExampleFragment extends Fragment {
    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        RegisterIntentFilters();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        UnregisterIntentFilters();
    }

    private void RegisterIntentFilters()
    {
        Context c = getContext();

        if(c != null)
        {
            Utils.tryRegisterReceiver(c, Receiver_CardReaderEvents, new IntentFilter(CardknoxSDK.CARDREADER_CALLBACK_INTENTFILTER_ACTION()));
        }
    }

    private void UnregisterIntentFilters()
    {
        Context c = this.getContext();

        if(c != null)
        {
            Utils.tryUnregisterReceiver(c, Receiver_CardReaderEvents);
        }
    }

    private final BroadcastReceiver Receiver_CardReaderEvents = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDK.CARDREADER_CALLBACK_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDK.CARDREADER_CALLBACK_INTENTFILTER_EXTRA();
                CardknoxCardReaderCallback callback = intent.getParcelableExtra(extraKey);

                // Read the event code
                int code = callback.GetCode();

                // Read the event name
                String name = callback.GetName();

                Output("Card reader event: " + name);

                // Match the non-error code; for example "connected"
                if(code == CardknoxCardReaderCallbackType.CONNECTED){
                    Output("Connected!");
                }

                // Extract the message when there's an error
                if(code == CardknoxCardReaderCallbackType.ERROR){
                    String message = callback.GetMessage();
                    Output("Card reader event: " + message);
                }
            }
        }
    };

    private void Output(String text)
    {
        android.util.Log.d("ExampleTag", text);
    }
}
