package com.cardknox.android.sdk.sampleapp2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;

public class Utils {
    public static void tryUnregisterReceiver(Context x, BroadcastReceiver receiver){
        try { x.unregisterReceiver(receiver); }
        catch(NullPointerException e) { /* context */}
        catch(IllegalArgumentException e2) { /* already unregistered */ }
    }

    public static void tryRegisterReceiver(Context x, BroadcastReceiver receiver, IntentFilter intentFilter){
        try {

            if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.UPSIDE_DOWN_CAKE){
                /**
                 *
                 *          Use Context.RECEIVER_EXPORTED during registration.
                 *          Otherwise the broadcasts are not going to arrive into this app
                 *
                 * */
                x.registerReceiver(receiver, intentFilter, Context.RECEIVER_EXPORTED);
            }
            else{
                x.registerReceiver(receiver, intentFilter);
            }
        }
        catch(Exception e){
            e.printStackTrace();
        }
    }

    private static final String TAG = "CardknoxDroidSampleApp";

    public static void log(String message)
    {
        android.util.Log.d(TAG, message);
    }
}
