package com.cardknox.android.sdk.sampleapp2;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.NumberPicker;
import android.widget.Toast;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.cardknox.android.sdk.sampleapp2.databinding.OutofscopeFragmentBinding;
import com.cardknox.android.sdk.sampleapp2.options.TransactionParametersContract;

import cardknox.payments.sdk.CardknoxCardReaderCallback;
import cardknox.payments.sdk.CardknoxSDK;
import cardknox.payments.sdk.PaymentTransactionRequestUI;
import cardknox.payments.sdk.PaymentTransactionResponse;
import cardknox.payments.sdk.TransactionParameters;
import cardknox.payments.sdk.CardknoxSDKUI;

public class OutOfScopeFragment extends Fragment
        implements ActivityResultCallback<TransactionParameters>
{
    private OutofscopeFragmentBinding binding;
    private String[] commands;
    private boolean openingCardknoxUI;
    private TransactionParameters currentParameters = new TransactionParameters();

    @Override
    public void onResume() {
        super.onResume();
        RegisterAllIntentFilters();
    }

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState)
    {
        commands = Commands.GetCommandsArray();
        binding = OutofscopeFragmentBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        // Command dropdown
        ArrayAdapter<String> aa = new ArrayAdapter<String>(getActivity(),
                R.layout.my_simple_spinner_item,
                commands);

        aa.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        binding.spinnerTransactionType.setAdapter(aa);

        binding.btnExecuterequest.setOnClickListener(Button_ExecuteRequest);
        binding.btnClearoutput.setOnClickListener(v -> binding.output.setText(""));
        binding.btnMoreoptions.setOnClickListener(v -> openOptionsScreen());
    }

    private void openOptionsScreen(){
        openOptionsLauncher.launch(currentParameters);
    }

    private final ActivityResultLauncher<TransactionParameters> openOptionsLauncher =
            registerForActivityResult(new TransactionParametersContract(), this);


    private final View.OnClickListener Button_ExecuteRequest = v -> {

        // Define global screen accessibility before creating a Request object via the SDK.
        // Changing these values after the Request is created will not have an affect until the
        // Request is re-created.

        CardknoxSDK.create().getOutOfScope().SetEnableDeviceInsertSwipeTap(binding.checkboxSwipe.isChecked());
        CardknoxSDK.create().getOutOfScope().SetEnableKeyedEntry(binding.checkboxManual.isChecked());

        // Configure what should happen once the UI processes a transaction
        // If the SDK should not close itself, then the transaction processing results are displayed in a modal window.
        // Otherwise the SDK auto closes its' UI.
        CardknoxSDK.create().getOutOfScope().SetCloseSDKUIOnProcessedTransaction(binding.checkboxClosesdkAfterprocessing.isChecked());

        // Validate amount
        double amount;
        try {
            amount = Double.parseDouble(binding.amount.getText().toString());
            currentParameters.SetxAmount(amount);
        } catch (NumberFormatException e) {
            Toast.makeText(getContext(), "Amount is invalid", Toast.LENGTH_SHORT).show();
            return;
        }

        // Command
        String command = binding.spinnerTransactionType.getSelectedItem().toString();
        currentParameters.SetxCommand(command);

        currentParameters.SetVP3300TransactionTimeout(14);


// Documentation - vp3300 timeout
if(false) {
CardknoxSDKUI ui = CardknoxSDK.create().getOutOfScope();
TransactionParameters parameters = new TransactionParameters();
parameters.SetVP3300TransactionTimeout(13);
PaymentTransactionRequestUI req = ui.createRequestWithParameters(parameters);
// Enable swipe screen in the Cardknox UI
CardknoxSDK.create().getOutOfScope().SetEnableDeviceInsertSwipeTap(true);
// Show Cardknox UI
Activity activity = null; // Obtain an Activity reference
req.process(activity);
}


        // Request
        PaymentTransactionRequestUI request = CardknoxSDK.create().getOutOfScope().createRequestWithParameters(currentParameters);

        if (request.GetIsValid()) {
            openingCardknoxUI = true;
            // Show Cardknox SDK UI
            request.process(getActivity());
        }
        else {
            String[] validationErrors = request.GetValidationErrors();
            // Output errors to UI
            for (String e : validationErrors) {
                Output(e);
            }

            Toast.makeText(getContext(), "Request is invalid. Check the output window.", Toast.LENGTH_SHORT).show();
        }
    };

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // Configure the Cardknox SDK with an xKey
        CardknoxSDK.create().setPrincipalKey(MainActivity2.KEY);

        // Supply the Cardknox SDK with the required values:
        // xSoftware name: name of your application
        // xVersion: Cardknox Gateway version. Currently 4.5.9
        CardknoxSDK.create().setSoftwareConfigurations(
                // xSoftwareName
                "Cardknox Android SDK sample Java app - process out of scope",
                // xVersion
                "4.5.9");
    }

    /**
     * Called when the Fragment is about to become visible on the UI.
     * Good place to register BroadcastReceivers.
     * */
    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);

        // Does this execute when we show new activity?
        if(openingCardknoxUI) {
            openingCardknoxUI = false;
        }

        RegisterAllIntentFilters();
    }

    /**
     * This is called when switching Fragments.
     * Fragment will be removed from the screen.
     * Can't rely on onDetach - it is not invoked on switching Fragments
     *
     * Good place to unregister BroadcastReceivers.
     * */
    @Override
    public void onPause() {
        super.onPause();

        if(!openingCardknoxUI) {
            UnregisterAllIntentFilters();
        }
    }

    private void RegisterAllIntentFilters()
    {
        Context c = getContext();

        if(c != null)
        {
            Utils.tryRegisterReceiver(c, Receiver_TransactionProcessing, new IntentFilter(CardknoxSDK.TRANSACTION_CALLBACK_INTENTFILTER_ACTION()));
            Utils.tryRegisterReceiver(c, Receiver_CardReaderEvents, new IntentFilter(CardknoxSDK.CARDREADER_CALLBACK_INTENTFILTER_ACTION()));
        }
    }

    private void UnregisterAllIntentFilters()
    {
        Context c = this.getContext();

        if(c != null)
        {
            Utils.tryUnregisterReceiver(c, Receiver_TransactionProcessing);
            Utils.tryUnregisterReceiver(c, Receiver_CardReaderEvents);
        }
    }

    private final BroadcastReceiver Receiver_TransactionProcessing = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDK.TRANSACTION_CALLBACK_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDK.TRANSACTION_CALLBACK_INTENTFILTER_EXTRA();
                java.lang.Object extra = intent.getParcelableExtra(extraKey);

                // Cast the 'extra' to the Cardknox SDK response type
                PaymentTransactionResponse response = (PaymentTransactionResponse)extra;

                if(response.GetIsSuccess())
                {
                    Toast.makeText(getContext(), "Transaction approved.", Toast.LENGTH_SHORT).show();
                    Output("Transaction approved. Ref num: " + response.GetxRefNum());
                }
                else{
                    Toast.makeText(getContext(), "Transaction declined/errored", Toast.LENGTH_SHORT).show();
                    Output("Transaction declined/errored. Ref num: " + response.GetxRefNum());
                }
            }
        }
    };

    private final BroadcastReceiver Receiver_CardReaderEvents = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDK.CARDREADER_CALLBACK_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDK.CARDREADER_CALLBACK_INTENTFILTER_EXTRA();
                CardknoxCardReaderCallback callback = intent.getParcelableExtra(extraKey);
                int code = callback.GetCode();
                String name = callback.GetName();
                String message = callback.GetMessage();

                Output("Card reader event: " + name);

                if(message != null && !message.isEmpty())
                {
                    Output("Card reader event: " + message);
                }
            }
        }
    };

    private void Output(String text) {
        if (text != null && text.length() > 0)
            binding.output.append("\n" + text);
    }

    @Override
    public void onActivityResult(TransactionParameters result)
    {
        // Snapshot current state that should not be changed
        String oldCommand = currentParameters.GetxCommand();
        String oldxExp = currentParameters.GetxExp();
        String oldDesc = currentParameters.GetxDescription();
        double oldAmount = currentParameters.GetxAmount();

        // Apply all changes
        currentParameters = result;

        // Restore state for snapshoted values
        currentParameters.SetxCommand(oldCommand);
        currentParameters.SetxExp(oldxExp);
        currentParameters.SetxDescription(oldDesc);
        currentParameters.SetxAmount(oldAmount);
    }
}
