package com.cardknox.android.sdk.sampleapp2;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.NumberPicker;
import android.widget.RelativeLayout;

import java.time.LocalDate;

public class MonthYearPickerView extends RelativeLayout {

    private NumberPicker.OnValueChangeListener externalMonthChangeListener;
    private NumberPicker.OnValueChangeListener externalYearChangeListener;

    public void SetMonthChangedListener(NumberPicker.OnValueChangeListener listener)
    {
        this.externalMonthChangeListener = listener;
    }

    public void SetYearChangedListener(NumberPicker.OnValueChangeListener listener)
    {
        this.externalYearChangeListener = listener;
    }

    private static final int MaxNumberOfMonths = 12;
    private static final int MaxNumberOfYears = 2100;
    private static final int MinNumberOfMonths = 1;
    private static final int MinNumberOfYears = 1900;

    private NumberPicker _monthPicker;
    private NumberPicker _yearPicker;

    public int currentMonth;
    public int currentYear;



    public MonthYearPickerView(Context context) {
        this(context, null, 0, 0);
    }

    public MonthYearPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0, 0);
    }

    public MonthYearPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public MonthYearPickerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();

        _monthPicker = findViewById(R.id.picker_month);
        _yearPicker = findViewById(R.id.picker_year);

        // Why java.util.Date and java.util.Calendar are bad to use + alternatives.
        // Source: https://stackoverflow.com/a/21598394

        LocalDate now = LocalDate.now();
        if(InScopeFragment.selectedMonth != null) {
            currentMonth = InScopeFragment.selectedMonth;
        }
        else{
            currentMonth = now.getMonth().getValue();
        }

        if(InScopeFragment.selectedYear != null){
            currentYear = InScopeFragment.selectedYear;
        }
        else{
            currentYear = now.getYear();
        }

        InitializeMonthPicker(currentMonth);
        InitializeYearPicker(currentYear);

        // TODO: implement
        //SetMaxMinDate(maxDate, minDate);
    }

    private void InitializeMonthPicker(int month)
    {
        _monthPicker.setMinValue(MinNumberOfMonths);
        _monthPicker.setMaxValue(MaxNumberOfMonths);
        _monthPicker.setValue(month);
        _monthPicker.setOnValueChangedListener(MonthPicker_OnValueChangedListener);
        _monthPicker.setDisplayedValues(GetMonthNames());
        _monthPicker.setWrapSelectorWheel(false);
        _monthPicker.setDescendantFocusability(FOCUS_BLOCK_DESCENDANTS);
    }

    private void InitializeYearPicker(int year)
    {
        _yearPicker.setMinValue(MinNumberOfYears);
        _yearPicker.setMaxValue(MaxNumberOfYears);
        _yearPicker.setValue(year);
        _yearPicker.setOnScrollChangeListener(YearPicker_OnScrollChangeListener);
        _yearPicker.setOnValueChangedListener(YearPicker_OnValueChangedListener);
        _yearPicker.setWrapSelectorWheel(false);
        _yearPicker.setDescendantFocusability(FOCUS_BLOCK_DESCENDANTS);
    }

    private String[] GetMonthNames(){
        return new String[] {
                "01 January",
                "02 February",
                "03 March",
                "04 April",
                "05 May",
                "06 June",
                "07 July",
                "08 August",
                "09 September",
                "10 October",
                "11 November",
                "12 December"
        };
    }

    private final NumberPicker.OnValueChangeListener MonthPicker_OnValueChangedListener = new NumberPicker.OnValueChangeListener(){

        @Override
        public void onValueChange(NumberPicker numberPicker, int oldVal, int newVal) {
            if(externalMonthChangeListener != null)
                externalMonthChangeListener.onValueChange(numberPicker, oldVal, newVal);
        }
    };

    private final OnScrollChangeListener YearPicker_OnScrollChangeListener = new OnScrollChangeListener() {
        @Override
        public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY){

        }
    };

    private final NumberPicker.OnValueChangeListener YearPicker_OnValueChangedListener = new NumberPicker.OnValueChangeListener(){

        @Override
        public void onValueChange(NumberPicker numberPicker, int oldVal, int newVal) {
            if(externalYearChangeListener != null)
                externalYearChangeListener.onValueChange(numberPicker, oldVal, newVal);
        }
    };
}
