package com.cardknox.android.sdk.sampleapp2;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import android.widget.Button;
import android.widget.NumberPicker;

import androidx.annotation.NonNull;

public class MonthYearPickerDialog extends Dialog {

    private NumberPicker.OnValueChangeListener externalMonthChangeListener;
    private NumberPicker.OnValueChangeListener externalYearChangeListener;
    private MonthYearPickerView _view;

    public MonthYearPickerDialog(@NonNull Context context) {
        super(context);
    }

    /**
     * "dismiss" call happens after a "cancel"
     */
    @Override
    public void dismiss() {
        super.dismiss();
    }

    @Override
    public void cancel() {
        super.cancel();
    }

    public void show()
    {
        // Triggers onCreate
        super.show();

        this.externalMonthChangeListener.onValueChange(null, 0, _view.currentMonth);
        this.externalYearChangeListener.onValueChange(null, 0, _view.currentYear);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        _view = (MonthYearPickerView) this.getLayoutInflater().inflate(R.layout.date_picker_dialog, null);
        _view.SetMonthChangedListener(this.externalMonthChangeListener);
        _view.SetYearChangedListener(this.externalYearChangeListener);
        setContentView(_view);
    }

    public void SetMonthChangedListener(NumberPicker.OnValueChangeListener listener)
    {
        this.externalMonthChangeListener = listener;
    }

    public void SetYearChangedListener(NumberPicker.OnValueChangeListener listener)
    {
        this.externalYearChangeListener = listener;
    }
}

