package com.cardknox.android.sdk.sampleapp2;

import android.content.Context;
import android.os.Bundle;

import com.google.android.material.bottomnavigation.BottomNavigationView;

import androidx.appcompat.app.AppCompatActivity;

import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.NavigationUI;
import cardknox.payments.sdk.CardknoxSDK;
import cardknox.payments.sdk.CardknoxSDKVersion;

import com.cardknox.android.sdk.sampleapp2.databinding.ActivityMain2Binding;

public class MainActivity2 extends AppCompatActivity {

    public static final String KEY = BuildConfig.xKEY;

    private AppBarConfiguration appBarConfiguration;
    private ActivityMain2Binding binding;

    @Override
    protected void onDestroy() {
        super.onDestroy();
        CardknoxSDK.create().destroy();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        binding = ActivityMain2Binding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        setSupportActionBar(binding.toolbar);

        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment_content_main);

        BottomNavigationView bnv = findViewById(R.id.bottom_nav_view);
        // Include all fragment ids as the Builder parameter.
        // This way all the fragments are "top level destinations" and do not have a "back button"
        // when switched to.
        appBarConfiguration = new AppBarConfiguration.Builder(R.id.InScopeFragment, R.id.CustomUIBLEFragment, R.id.CustomUIUSBFragment, R.id.OutOfScopeFragment, R.id.PaymentEngineFragment).build();

        NavigationUI.setupActionBarWithNavController(this, navController, appBarConfiguration);
        NavigationUI.setupWithNavController(bnv, navController);
    }

    @Override
    public boolean onSupportNavigateUp() {
        NavController navController = Navigation.findNavController(this, R.id.nav_host_fragment_content_main);
        return NavigationUI.navigateUp(navController, appBarConfiguration)
                || super.onSupportNavigateUp();
    }
}