package com.cardknox.android.sdk.sampleapp2;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.NumberPicker;
import android.widget.Toast;

import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;

import com.cardknox.android.sdk.sampleapp2.databinding.InscopeFragmentBinding;
import com.cardknox.android.sdk.sampleapp2.options.AdvancedOptionsActivity;
import com.cardknox.android.sdk.sampleapp2.options.TransactionParametersContract;

import cardknox.payments.sdk.CardknoxSDK;
import cardknox.payments.sdk.CardknoxSDKDirect;
import cardknox.payments.sdk.CardknoxSDKUI;
import cardknox.payments.sdk.PaymentTransactionRequestDirect;
import cardknox.payments.sdk.PaymentTransactionResponse;
import cardknox.payments.sdk.TransactionParameters;

public class InScopeFragment extends Fragment
        implements ActivityResultCallback<TransactionParameters> {


    // State
    public static Integer selectedYear;
    public static Integer selectedMonth;
    private String[] commands;
    private TransactionParameters currentParameters = new TransactionParameters();

    // Views
    private InscopeFragmentBinding binding;
    private MonthYearPickerDialog expirationDateDialog;


    private final DialogInterface.OnCancelListener ExpirationDatePicker_OnCancelListener = new DialogInterface.OnCancelListener() {
        @Override
        public void onCancel(DialogInterface dialogInterface) {
            expirationDateDialog = null;
        }
    };

    private final NumberPicker.OnValueChangeListener ExpirationDatePicker_MonthChanged = new NumberPicker.OnValueChangeListener() {
        @Override
        public void onValueChange(NumberPicker numberPicker, int oldVal, int newVal) {
            // month change
            selectedMonth = newVal;
            UpdateExpirationDateText();
        }
    };


    private final NumberPicker.OnValueChangeListener ExpirationDatPicker_YearChanged = new NumberPicker.OnValueChangeListener() {
        @Override
        public void onValueChange(NumberPicker numberPicker, int oldVal, int newVal) {
            // year change
            selectedYear = newVal;
            UpdateExpirationDateText();
        }
    };

    private void UpdateExpirationDateText() {
        if (selectedYear != null && selectedMonth != null) {
            String formatted = String.format("%s%s", DoubleDigitMonth(selectedMonth), Last2DigitsYear(selectedYear));
            binding.textExpirationdate.setText(formatted);
        }
    }

    private int Last2DigitsYear(int year) {
        return year - 2000;
    }

    /**
     * Hey; it works :)
     *
     * @param month
     * @return
     */
    private String DoubleDigitMonth(int month) {
        switch (month) {
            case 1:
                return "01";
            case 2:
                return "02";
            case 3:
                return "03";
            case 4:
                return "04";
            case 5:
                return "05";
            case 6:
                return "06";
            case 7:
                return "07";
            case 8:
                return "08";
            case 9:
                return "09";
            case 10:
                return "10";
            case 11:
                return "11";
            case 12:
                return "12";
            default:
                throw new IllegalArgumentException(month + " falls out of the 1-12 range");
        }
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        // Configure the Cardknox SDK with an xKey
        CardknoxSDK.create().setPrincipalKey(MainActivity2.KEY);

        // Supply the Cardknox SDK with the required values:
        // xSoftware name: name of your application
        // xVersion: Cardknox Gateway version. Currently 4.5.9
        CardknoxSDK.create().setSoftwareConfigurations(
                // xSoftwareName
                "Cardknox Android SDK sample Java app - process in scope",
                // xVersion
                "4.5.9");
    }

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {
        commands = Commands.GetCommandsArray();
        binding = InscopeFragmentBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        // Command dropdown
        ArrayAdapter<String> aa = new ArrayAdapter<String>(getActivity(),
                R.layout.my_simple_spinner_item,
                commands);

        aa.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        binding.spinnerTransactionType.setAdapter(aa);

        // Other views
        binding.btnExecuterequest.setOnClickListener(view12 -> executeProcessInScope());
        binding.btnClearoutput.setOnClickListener(v -> binding.output.setText(""));
        binding.btnMoreoptions.setOnClickListener(v -> openOptionsScreen());

        binding.textExpirationdate.setOnClickListener(view1 -> {
            Context c = getContext();
            if (c != null) {
                if (expirationDateDialog == null) {
                    expirationDateDialog = new MonthYearPickerDialog(c);
                    expirationDateDialog.setOnCancelListener(ExpirationDatePicker_OnCancelListener);
                    expirationDateDialog.SetMonthChangedListener(ExpirationDatePicker_MonthChanged);
                    expirationDateDialog.SetYearChangedListener(ExpirationDatPicker_YearChanged);
                }

                expirationDateDialog.show();
            }
        });
    }

    private void openOptionsScreen(){
        openOptionsLauncher.launch(currentParameters);
    }

    private final ActivityResultLauncher<TransactionParameters> openOptionsLauncher =
            registerForActivityResult(new TransactionParametersContract(), this);

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onActivityResult(TransactionParameters result)
    {
        // Snapshot current state that should not be changed
        String oldCommand = currentParameters.GetxCommand();
        String oldxExp = currentParameters.GetxExp();
        double oldAmount = currentParameters.GetxAmount();

        // Apply all changes
        currentParameters = result;

        // Restore state for snapshoted values
        currentParameters.SetxCommand(oldCommand);
        currentParameters.SetxExp(oldxExp);
        currentParameters.SetxAmount(oldAmount);
    }

    private void executeProcessInScope() {
        // Validate amount
        double amount;
        try {
            amount = Double.parseDouble(binding.amount.getText().toString());
        } catch (NumberFormatException e) {
            Toast.makeText(getContext(), "Amount is invalid", Toast.LENGTH_SHORT).show();
            return;
        }

        // Command
        String command = binding.spinnerTransactionType.getSelectedItem().toString();
        currentParameters.SetxCommand(command);
        currentParameters.SetxAmount(amount);
        currentParameters.SetxToken(binding.xtoken.getText().toString());

        currentParameters.SetxCardNum(binding.cardNumber.getText().toString());
        currentParameters.SetxExp(binding.textExpirationdate.getText().toString());

        PaymentTransactionRequestDirect request = CardknoxSDK.create().getInScope().createRequestWithParameters(currentParameters);

        if (request.GetIsValid()) {
            PaymentTransactionResponse response = request.process();

            if (response.GetIsSuccess()) {
                Output("Transaction approved. Ref num: " + response.GetxRefNum());
            } else {
                Output("Transaction failed");
                Output("Error message: " + response.GetErrorMessage());
                Output("Error: " + response.GetxError());
                Output("Error code: " + response.GetxErrorCode());
                Output("Ref num: " + response.GetxRefNum());

                Toast.makeText(getContext(), "Transaction approved.", Toast.LENGTH_SHORT).show();
            }
        } else {
            String[] validationErrors = request.GetValidationErrors();
            // Output errors to UI
            for (String e : validationErrors) {
                Output(e);
            }

            Toast.makeText(getContext(), "Request is invalid. Check the output window.", Toast.LENGTH_SHORT).show();
        }
    }

    private void Output(String text) {
        if (text != null && text.length() > 0)
            binding.output.append("\n" + text);
    }
}