package com.cardknox.android.sdk.sampleapp2;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Toast;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.cardknox.android.sdk.sampleapp2.databinding.CustomuiBleFragmentBinding;
import com.cardknox.android.sdk.sampleapp2.options.TransactionParametersContract;

import net.dot.android.crypto.DotnetProxyTrustManager;

import cardknox.payments.sdk.CardknoxCardReaderCallback;
import cardknox.payments.sdk.CardknoxCardReaderCallbackType;
import cardknox.payments.sdk.CardknoxSDK;
import cardknox.payments.sdk.CardknoxSDKCustomUIBLE;
import cardknox.payments.sdk.CardknoxSDKCustomUIBLEScanCompleted;
import cardknox.payments.sdk.CardknoxSDKCustomUIBLEScannedDevice;
import cardknox.payments.sdk.PaymentTransactionResponse;
import cardknox.payments.sdk.TransactionParameters;

public class CustomUIBluetoothFragment extends Fragment
        implements ActivityResultCallback<TransactionParameters>
{

    private CustomuiBleFragmentBinding binding;
    private String[] commands;
    private TransactionParameters currentParameters = new TransactionParameters();
    private String[] timeouts = new String[]{"0", "20"};

    private String getSelectedTimeout() {
        return binding.spinnerTimeouts.getSelectedItem().toString();
    }

    private String getSelectedTransactionType() {
        return binding.spinnerTransactionType.getSelectedItem().toString();
    }



    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // Configure the Cardknox SDK with an xKey
        CardknoxSDK.create().setPrincipalKey(MainActivity2.KEY);

        // Supply the Cardknox SDK with the required values:
        // xSoftware name: name of your application
        // xVersion: Cardknox Gateway version. Currently 4.5.9
        CardknoxSDK.create().setSoftwareConfigurations(
                // xSoftwareName
                "Cardknox Android SDK sample Java app - custom ui",
                // xVersion
                "4.5.9");
    }

    @Override
    public View onCreateView(
            LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState
    ) {

        commands = Commands.GetCommandsArray();
        binding = CustomuiBleFragmentBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    /**
     * Called when the Fragment is about to become visible on the UI.
     * Good place to register BroadcastReceivers.
     * */
    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
//        RegisterAllIntentFilters();
    }

    /**
     * This is called when switching Fragments.
     * Fragment will be removed from the screen.
     * Can't rely on onDetach - it is not invoked on switching Fragments
     *
     * Good place to unregister BroadcastReceivers.
     * */
    @Override
    public void onPause() {
        super.onPause();
        UnregisterAllIntentFilters();
    }

    @Override
    public void onResume() {
        super.onResume();
        RegisterAllIntentFilters();
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        // Command dropdown
        ArrayAdapter<String> aa = new ArrayAdapter<String>(getActivity(),
                R.layout.my_simple_spinner_item,
                commands);

        aa.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        binding.spinnerTransactionType.setAdapter(aa);

        // Timeouts spinner
        ArrayAdapter<String> timeoutsAdapter = new ArrayAdapter<>(getActivity(),
                android.R.layout.simple_spinner_item,
                timeouts);
        timeoutsAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        binding.spinnerTimeouts.setAdapter(timeoutsAdapter);

        // Buttons
        binding.btnConnect.setOnClickListener(Button_ConnectListener);
        binding.btnDisconnect.setOnClickListener(Button_DisconnectListener);
        binding.btnStartScanning.setOnClickListener(Button_StartScanning);
        binding.btnStopScanning.setOnClickListener(Button_StopScanning);
        binding.btnStartTransaction.setOnClickListener(Button_StartTransaction);
        binding.btnStopTransaction.setOnClickListener(Button_StopTransaction);
        binding.btnClearoutput.setOnClickListener(v -> binding.output.setText(""));
        binding.btnMoreoptions.setOnClickListener(v -> openOptionsScreen());
    }

    private void openOptionsScreen(){
        openOptionsLauncher.launch(currentParameters);
    }

    private final ActivityResultLauncher<TransactionParameters> openOptionsLauncher =
            registerForActivityResult(new TransactionParametersContract(), this);

    @Override
    public void onActivityResult(TransactionParameters result)
    {
        // Snapshot current state that should not be changed
        String oldCommand = currentParameters.GetxCommand();
        double oldAmount = currentParameters.GetxAmount();

        // Apply all changes
        currentParameters = result;

        // Restore state for snapshoted values
        currentParameters.SetxCommand(oldCommand);
        currentParameters.SetxAmount(oldAmount);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    private final View.OnClickListener Button_ConnectListener = new View.OnClickListener() {
        @Override
        public void onClick(View view) {

            // Documentation purposes:
            if(false)
            {
                CardknoxSDKCustomUIBLEScannedDevice exampleDevice = null;
                CardknoxSDKCustomUIBLE exampleCustomUI = null;
                exampleCustomUI.connectWithAddress(exampleDevice.GetAddress());
            }

            Object selectedItem = binding.spinnerScannedDevices.getSelectedItem();

            if(selectedItem != null) {
                CardknoxSDK.create().getCustomUIBluetooth().connectWithName(selectedItem.toString());

            }else{
                Toast.makeText(getContext(), "Cannot connect. Select a device to connect to", Toast.LENGTH_SHORT).show();
            }
        }
    };

    private final View.OnClickListener Button_DisconnectListener = view -> CardknoxSDK.create().getCustomUIBluetooth().disconnectFromCurrentDevice();

    private final View.OnClickListener Button_StartScanning = view -> {
        String timeout = getSelectedTimeout();
        CardknoxSDK.create().getCustomUIBluetooth().startScanningWithTimeout(Integer.parseInt(timeout));
    };

    private final View.OnClickListener Button_StopScanning = view -> CardknoxSDK.create().getCustomUIBluetooth().stopScanning();

    private final View.OnClickListener Button_StartTransaction = new View.OnClickListener() {
        @Override
        public void onClick(View view) {

            // Validate amount
            double amount;
            try {
                amount = Double.parseDouble(binding.amount.getText().toString());
            } catch (NumberFormatException e) {
                Toast.makeText(getContext(), "Amount is invalid", Toast.LENGTH_SHORT).show();
                return;
            }

            currentParameters.SetxCommand(getSelectedTransactionType());
            currentParameters.SetxAmount(amount);
            currentParameters.SetVP3300TransactionTimeout(16);
            CardknoxSDK.create().getCustomUIBluetooth().startTransactionWithArgs(currentParameters);
        }
    };

    private final View.OnClickListener Button_StopTransaction = new View.OnClickListener() {
        @Override
        public void onClick(View view) {
            try {
                CardknoxSDK.create().getCustomUIBluetooth().cancelTransaction();
            }
            catch(Exception e)
            {
                String message = "Stop transaction error: " + e.getMessage();
                Toast.makeText(getContext(), message, Toast.LENGTH_LONG).show();
            }
        }
    };

    private void RegisterAllIntentFilters()
    {
        Context c = getContext();

        if(c != null)
        {
            String Receiver_TransactionProcessing_Action = CardknoxSDK.TRANSACTION_CALLBACK_INTENTFILTER_ACTION();
            String Receiver_ScannedDevice_Action = CardknoxSDKCustomUIBLE.SCANNED_DEVICE_INTENTFILTER_ACTION();
            String Receiver_ScanCompleted_Action = CardknoxSDKCustomUIBLE.SCAN_COMPLETED_INTENTFILTER_ACTION();
            String Receiver_CardReaderEvents_Action = CardknoxSDK.CARDREADER_CALLBACK_INTENTFILTER_ACTION();
            Utils.tryRegisterReceiver(c, Receiver_TransactionProcessing, new IntentFilter(Receiver_TransactionProcessing_Action));
            Utils.tryRegisterReceiver(c, Receiver_CardReaderEvents, new IntentFilter(Receiver_CardReaderEvents_Action));
            Utils.tryRegisterReceiver(c, Receiver_ScannedDevice, new IntentFilter(Receiver_ScannedDevice_Action));
            Utils.tryRegisterReceiver(c, Receiver_ScanCompleted, new IntentFilter(Receiver_ScanCompleted_Action));
        }
    }

    private void UnregisterAllIntentFilters()
    {
        Context c = this.getContext();

        if(c != null)
        {
            Utils.tryUnregisterReceiver(c, Receiver_TransactionProcessing);
            Utils.tryUnregisterReceiver(c, Receiver_CardReaderEvents);
            Utils.tryUnregisterReceiver(c, Receiver_ScannedDevice);
            Utils.tryUnregisterReceiver(c, Receiver_ScanCompleted);
        }
    }

    private final BroadcastReceiver Receiver_TransactionProcessing = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDK.TRANSACTION_CALLBACK_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDK.TRANSACTION_CALLBACK_INTENTFILTER_EXTRA();
                java.lang.Object extra = intent.getParcelableExtra(extraKey);

                // Cast the 'extra' to the Cardknox SDK response type
                PaymentTransactionResponse response = (PaymentTransactionResponse)extra;

                if(response.GetIsSuccess())
                {
                    Context ctx = getContext();
                    if(ctx != null)
                        Toast.makeText(ctx, "Transaction approved.", Toast.LENGTH_SHORT).show();
                    Output("Transaction approved. Ref num: " + response.GetxRefNum());
                }
                else{
                    Toast.makeText(getContext(), "Transaction declined/errored", Toast.LENGTH_SHORT).show();
                    Output("Transaction declined/errored. Ref num: " + response.GetxRefNum());
                }
            }
        }
    };

    private final BroadcastReceiver Receiver_CardReaderEvents = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDK.CARDREADER_CALLBACK_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDK.CARDREADER_CALLBACK_INTENTFILTER_EXTRA();
                CardknoxCardReaderCallback callback = intent.getParcelableExtra(extraKey);
                int code = callback.GetCode();
                String name = callback.GetName();
                String message = callback.GetMessage();
                String logTag = "CardknoxDroidSampleApp";

                Output("Card reader event: " + name);

                if(message != null && !message.isEmpty())
                {
                    Output("Card reader event: " + message);
                }
            }
        }
    };

    private final BroadcastReceiver Receiver_ScannedDevice = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDKCustomUIBLE.SCANNED_DEVICE_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDKCustomUIBLE.SCANNED_DEVICE_INTENTFILTER_EXTRA();
                java.lang.Object extra = intent.getParcelableExtra(extraKey);
                CardknoxSDKCustomUIBLEScannedDevice device = (CardknoxSDKCustomUIBLEScannedDevice) extra;
                String message = String.format("Scanned device: %s - %s - %s", device.GetName(), device.GetDisplayName(), device.GetAddress());
                Output(message);
                Toast.makeText(getContext(), message, Toast.LENGTH_LONG).show();
            }
        }
    };

    private final BroadcastReceiver Receiver_ScanCompleted = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            String action = intent.getAction();

            // Verify that the Cardknox SDK broadcasted the Intent
            if(action.equals(CardknoxSDKCustomUIBLE.SCAN_COMPLETED_INTENTFILTER_ACTION()))
            {
                String extraKey = CardknoxSDKCustomUIBLE.SCAN_COMPLETED_INTENTFILTER_EXTRA();
                java.lang.Object extra = intent.getParcelableExtra(extraKey);
                CardknoxSDKCustomUIBLEScanCompleted scanCompleted = (CardknoxSDKCustomUIBLEScanCompleted) extra;

                if(scanCompleted != null && scanCompleted.scannedDevices() != null &&
                        scanCompleted.scannedDevices().size() > 0)
                {

                    int amount = scanCompleted.scannedDevices().size();
                    String[] deviceNames = new String[amount];

                    for(int i = 0; i < amount; i++)
                    {
                        deviceNames[i] = ((CardknoxSDKCustomUIBLEScannedDevice)scanCompleted.scannedDevices().get(i)).GetName();
                    }

                    // Timeouts spinner
                    ArrayAdapter<String> scannedDevicesAdapter = new ArrayAdapter<String>(getActivity(),
                            android.R.layout.simple_spinner_item,
                            deviceNames);
                    scannedDevicesAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                    binding.spinnerScannedDevices.setAdapter(scannedDevicesAdapter);
                }
            }
        }
    };

    private void Output(String text) {
        if (text != null && text.length() > 0)
            binding.output.append("\n" + text);
    }
}